//-----------------------------------------------------------------------------
// Remote Boss Example for C#Builder
//
// FormClient.cs
//
// This is the client application for the "Remote Boss" Remoting example. It
// demonstrates:
// 1) Getting an object instance using remoting.
// 2) Sending and returning objects via a remoting channel using TCP.
// 3) Using notifyIcon to hide the application in the notify area (system
//    tray).
// 4) Making a large PictureBox scrollable by placing it within a Panel.
//
// NOTE: This uses TCP port 3999. If that doesn't suit you then change it
//       in btnConnect_Click(). Make sure that you also change the
//       RemotingServer project to suit.
//
// By Jarrod Hollingworth
// 
//-----------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
// Remoting
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
// Remote Boss
using RemoteBoss;
// Screen Capture
using System.IO;

namespace RemotingClient
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class frmRemoteBossClient : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
    private System.Windows.Forms.Panel panel1;
    private System.Windows.Forms.Button btnGetScreen;
    private System.Windows.Forms.Button btnSendMessage;
    private System.Windows.Forms.TextBox txtMessage;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.Button btnConnect;
    private System.Windows.Forms.TextBox txtHost;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.TextBox txtProcess;
    private System.Windows.Forms.TextBox txtArguments;
    private System.Windows.Forms.Label label5;
    private System.Windows.Forms.Label lblLastScreenCapture;
    private System.Windows.Forms.Button btnRunProcess;
    private System.Windows.Forms.Panel pnlScreen;
    private System.Windows.Forms.PictureBox pbxScreen;

		public frmRemoteBossClient()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
      this.panel1 = new System.Windows.Forms.Panel();
      this.btnRunProcess = new System.Windows.Forms.Button();
      this.lblLastScreenCapture = new System.Windows.Forms.Label();
      this.label5 = new System.Windows.Forms.Label();
      this.txtArguments = new System.Windows.Forms.TextBox();
      this.txtProcess = new System.Windows.Forms.TextBox();
      this.label4 = new System.Windows.Forms.Label();
      this.label3 = new System.Windows.Forms.Label();
      this.btnGetScreen = new System.Windows.Forms.Button();
      this.btnSendMessage = new System.Windows.Forms.Button();
      this.txtMessage = new System.Windows.Forms.TextBox();
      this.label2 = new System.Windows.Forms.Label();
      this.btnConnect = new System.Windows.Forms.Button();
      this.txtHost = new System.Windows.Forms.TextBox();
      this.label1 = new System.Windows.Forms.Label();
      this.pnlScreen = new System.Windows.Forms.Panel();
      this.pbxScreen = new System.Windows.Forms.PictureBox();
      this.panel1.SuspendLayout();
      this.pnlScreen.SuspendLayout();
      this.SuspendLayout();
      // 
      // panel1
      // 
      this.panel1.Controls.Add(this.btnRunProcess);
      this.panel1.Controls.Add(this.lblLastScreenCapture);
      this.panel1.Controls.Add(this.label5);
      this.panel1.Controls.Add(this.txtArguments);
      this.panel1.Controls.Add(this.txtProcess);
      this.panel1.Controls.Add(this.label4);
      this.panel1.Controls.Add(this.label3);
      this.panel1.Controls.Add(this.btnGetScreen);
      this.panel1.Controls.Add(this.btnSendMessage);
      this.panel1.Controls.Add(this.txtMessage);
      this.panel1.Controls.Add(this.label2);
      this.panel1.Controls.Add(this.btnConnect);
      this.panel1.Controls.Add(this.txtHost);
      this.panel1.Controls.Add(this.label1);
      this.panel1.Dock = System.Windows.Forms.DockStyle.Top;
      this.panel1.Location = new System.Drawing.Point(0, 0);
      this.panel1.Name = "panel1";
      this.panel1.Size = new System.Drawing.Size(400, 320);
      this.panel1.TabIndex = 8;
      // 
      // btnRunProcess
      // 
      this.btnRunProcess.Enabled = false;
      this.btnRunProcess.Location = new System.Drawing.Point(4, 260);
      this.btnRunProcess.Name = "btnRunProcess";
      this.btnRunProcess.Size = new System.Drawing.Size(96, 23);
      this.btnRunProcess.TabIndex = 21;
      this.btnRunProcess.Text = "&Run Process";
      this.btnRunProcess.Click += new System.EventHandler(this.btnRunProcess_Click);
      // 
      // lblLastScreenCapture
      // 
      this.lblLastScreenCapture.AutoSize = true;
      this.lblLastScreenCapture.Location = new System.Drawing.Point(220, 292);
      this.lblLastScreenCapture.Name = "lblLastScreenCapture";
      this.lblLastScreenCapture.Size = new System.Drawing.Size(31, 16);
      this.lblLastScreenCapture.TabIndex = 20;
      this.lblLastScreenCapture.Text = "None";
      // 
      // label5
      // 
      this.label5.AutoSize = true;
      this.label5.Location = new System.Drawing.Point(108, 292);
      this.label5.Name = "label5";
      this.label5.Size = new System.Drawing.Size(111, 16);
      this.label5.TabIndex = 19;
      this.label5.Text = "Last Screen Capture:";
      // 
      // txtArguments
      // 
      this.txtArguments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
      this.txtArguments.Location = new System.Drawing.Point(104, 232);
      this.txtArguments.Name = "txtArguments";
      this.txtArguments.Size = new System.Drawing.Size(292, 20);
      this.txtArguments.TabIndex = 18;
      this.txtArguments.Text = "http://www.csharpbuilder.info";
      // 
      // txtProcess
      // 
      this.txtProcess.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
      this.txtProcess.Location = new System.Drawing.Point(104, 208);
      this.txtProcess.Name = "txtProcess";
      this.txtProcess.Size = new System.Drawing.Size(292, 20);
      this.txtProcess.TabIndex = 17;
      this.txtProcess.Text = "iexplore.exe";
      //
      // label4
      // 
      this.label4.AutoSize = true;
      this.label4.Location = new System.Drawing.Point(4, 236);
      this.label4.Name = "label4";
      this.label4.Size = new System.Drawing.Size(62, 16);
      this.label4.TabIndex = 16;
      this.label4.Text = "Arguments:";
      // 
      // label3
      // 
      this.label3.AutoSize = true;
      this.label3.Location = new System.Drawing.Point(4, 212);
      this.label3.Name = "label3";
      this.label3.Size = new System.Drawing.Size(88, 16);
      this.label3.TabIndex = 15;
      this.label3.Text = "Process To Run:";
      // 
      // btnGetScreen
      // 
      this.btnGetScreen.Enabled = false;
      this.btnGetScreen.Location = new System.Drawing.Point(4, 288);
      this.btnGetScreen.Name = "btnGetScreen";
      this.btnGetScreen.Size = new System.Drawing.Size(96, 23);
      this.btnGetScreen.TabIndex = 14;
      this.btnGetScreen.Text = "Get &Screen";
      this.btnGetScreen.Click += new System.EventHandler(this.btnScreenCapture_Click);
      // 
      // btnSendMessage
      // 
      this.btnSendMessage.Enabled = false;
      this.btnSendMessage.Location = new System.Drawing.Point(4, 176);
      this.btnSendMessage.Name = "btnSendMessage";
      this.btnSendMessage.Size = new System.Drawing.Size(96, 23);
      this.btnSendMessage.TabIndex = 13;
      this.btnSendMessage.Text = "&Send Message";
      this.btnSendMessage.Click += new System.EventHandler(this.btnSendMessage_Click);
      // 
      // txtMessage
      // 
      this.txtMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
      this.txtMessage.Enabled = false;
      this.txtMessage.Location = new System.Drawing.Point(4, 52);
      this.txtMessage.Multiline = true;
      this.txtMessage.Name = "txtMessage";
      this.txtMessage.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
      this.txtMessage.Size = new System.Drawing.Size(400, 120);
      this.txtMessage.TabIndex = 12;
      this.txtMessage.Text = @"All employees are to take a look at the CSharpBuilder.info web site, review it, and prepare a 10-page paper on the topic:
    Impact on Development Schedule Though Increased Knowledge
Deadline for paper submission is at the development meeting tomorrow morning - no extensions possible!

Oh, and I'm watching you!
- Stan, Your Boss";
      // 
      // label2
      //
      this.label2.AutoSize = true;
      this.label2.Location = new System.Drawing.Point(4, 36);
      this.label2.Name = "label2";
      this.label2.Size = new System.Drawing.Size(99, 16);
      this.label2.TabIndex = 11;
      this.label2.Text = "Message To Send:";
      // 
      // btnConnect
      // 
      this.btnConnect.Location = new System.Drawing.Point(252, 8);
      this.btnConnect.Name = "btnConnect";
      this.btnConnect.TabIndex = 10;
      this.btnConnect.Text = "&Connect";
      this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
      // 
      // txtHost
      // 
      this.txtHost.Location = new System.Drawing.Point(84, 8);
      this.txtHost.Name = "txtHost";
      this.txtHost.Size = new System.Drawing.Size(160, 20);
      this.txtHost.TabIndex = 9;
      this.txtHost.Text = "localhost";
      // 
      // label1
      // 
      this.label1.AutoSize = true;
      this.label1.Location = new System.Drawing.Point(4, 12);
      this.label1.Name = "label1";
      this.label1.Size = new System.Drawing.Size(70, 16);
      this.label1.TabIndex = 8;
      this.label1.Text = "Worker Host:";
      // 
      // pnlScreen
      // 
      this.pnlScreen.AutoScroll = true;
      this.pnlScreen.Controls.Add(this.pbxScreen);
      this.pnlScreen.Dock = System.Windows.Forms.DockStyle.Fill;
      this.pnlScreen.Location = new System.Drawing.Point(0, 320);
      this.pnlScreen.Name = "pnlScreen";
      this.pnlScreen.Size = new System.Drawing.Size(400, 142);
      this.pnlScreen.TabIndex = 9;
      // 
      // pbxScreen
      // 
      this.pbxScreen.Location = new System.Drawing.Point(0, 0);
      this.pbxScreen.Name = "pbxScreen";
      this.pbxScreen.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
      this.pbxScreen.TabIndex = 0;
      this.pbxScreen.TabStop = false;
      // 
      // frmRemoteBossClient
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(400, 462);
      this.Controls.Add(this.pnlScreen);
      this.Controls.Add(this.panel1);
      this.MinimumSize = new System.Drawing.Size(408, 496);
      this.Name = "frmRemoteBossClient";
      this.Text = "Remote Boss Client";
      this.panel1.ResumeLayout(false);
      this.pnlScreen.ResumeLayout(false);
      this.ResumeLayout(false);
    }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new frmRemoteBossClient());
		}

    private RemoteBossService RemoteBoss;

    private void btnConnect_Click(object sender, System.EventArgs e)
    {
      if (RemoteBoss == null) {
        // Get the remote boss object.
        try {
          RemoteBoss = (RemoteBossService)Activator.GetObject(
              typeof(RemoteBossService),
              "tcp://" + txtHost.Text + ":3999/RemoteBossService");
        }
        catch (Exception ex) {
          MessageBox.Show(ex.Message, "Exception");
          return;
        }

        // Connected.
        btnConnect.Enabled = false;
        txtMessage.Enabled = true;
        btnSendMessage.Enabled = true;
        btnGetScreen.Enabled = true;
        btnRunProcess.Enabled = true;
      }
    }

    private void btnSendMessage_Click(object sender, System.EventArgs e) {
      BossMessage Message = new BossMessage(txtMessage.Text);
      try {
        RemoteBoss.SendMessage(Message);
      }
      catch (Exception ex) {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnScreenCapture_Click(object sender, System.EventArgs e) {
      // Get the workers screen.
      BossScreen ScreenCapture;
      try {
        ScreenCapture = RemoteBoss.GetScreen();
      }
      catch (Exception ex) {
        MessageBox.Show(ex.Message);
        return;
      }
      // Display workers screen capture date-time.
      lblLastScreenCapture.Text = ScreenCapture.GetCaptureDateTime().ToString();
      // Display the image.
      pbxScreen.Image = Image.FromStream(ScreenCapture.GetImageStream());
    }

    private void btnRunProcess_Click(object sender, System.EventArgs e) {
      BossProcess PushProcess = new BossProcess(txtProcess.Text,
                                                txtArguments.Text);
      try {
        RemoteBoss.PushProcess(PushProcess);
      }
      catch (Exception ex) {
        MessageBox.Show(ex.Message);
      }
    }
  }
}
